import { jsx } from "react/jsx-runtime";
import { useValue } from "@tldraw/state-react";
import { memo, useRef } from "react";
import { useEditor } from "../../hooks/useEditor.mjs";
import { useEditorComponents } from "../../hooks/useEditorComponents.mjs";
const DefaultShapeIndicators = memo(function DefaultShapeIndicators2() {
  const editor = useEditor();
  const rPreviousSelectedShapeIds = useRef(/* @__PURE__ */ new Set());
  const idsToDisplay = useValue(
    "should display selected ids",
    () => {
      const prev = rPreviousSelectedShapeIds.current;
      const next = /* @__PURE__ */ new Set();
      if (
        // We only show indicators when in the following states...
        editor.isInAny(
          "select.idle",
          "select.brushing",
          "select.scribble_brushing",
          "select.editing_shape",
          "select.pointing_shape",
          "select.pointing_selection",
          "select.pointing_handle"
        ) && // ...but we hide indicators when we've just changed a style (so that the user can see the change)
        !editor.getInstanceState().isChangingStyle
      ) {
        const selected = editor.getSelectedShapeIds();
        for (const id of selected) {
          next.add(id);
        }
        if (editor.isInAny("select.idle", "select.editing_shape")) {
          const instanceState = editor.getInstanceState();
          if (instanceState.isHoveringCanvas && !instanceState.isCoarsePointer) {
            const hovered = editor.getHoveredShapeId();
            if (hovered) next.add(hovered);
          }
        }
      }
      if (prev.size !== next.size) {
        rPreviousSelectedShapeIds.current = next;
        return next;
      }
      for (const id of next) {
        if (!prev.has(id)) {
          rPreviousSelectedShapeIds.current = next;
          return next;
        }
      }
      return prev;
    },
    [editor]
  );
  const renderingShapes = useValue("rendering shapes", () => editor.getRenderingShapes(), [editor]);
  const { ShapeIndicator } = useEditorComponents();
  if (!ShapeIndicator) return null;
  return renderingShapes.map(({ id }) => /* @__PURE__ */ jsx(ShapeIndicator, { shapeId: id, hidden: !idsToDisplay.has(id) }, id + "_indicator"));
});
export {
  DefaultShapeIndicators
};
//# sourceMappingURL=DefaultShapeIndicators.mjs.map
